import { BUTTON_COLOR, GREYISH_BROWN } from 'constants/colors';

const styles = () => ({
    container: {
        '-webkit-app-region': 'drag !important',
        backgroundColor: '#2d2d2d',
        display: 'grid',
        gridTemplateColumns: '1fr repeat(1, auto) 1fr',
        gridColumnGap: 5,
        justifyItems: 'center',
        padding: '18px 36px 18px 7px'
    },
    containerBare: {
        position: 'absolute',
        right: 0,
        left: 0,
        top: 0,
        backgroundColor: '#ffffff00'
    },
    titleContainer: {
        gridColumnStart: 2,
        display: 'flex',
        flexDirection: 'row',
        alignItems: 'center'
    },
    titleText: {
        textTransform: 'uppercase',
        fontSize: 18,
        fontWeight: 'bold',
        color: '#fff',
        fontStretch: 'condensed',
        letterSpacing: '0.72px'
    },
    titleIcon: {
        marginRight: 12,
        height: 24
    },
    rightSide: {
        marginLeft: 'auto',
        display: 'flex',
        flexDirection: 'row',
        alignItems: 'center'
    },
    languagePaper: {
        top: '62px !important',
        right: 92,
        left: 'auto !important'
    },
    languageInput: {
        color: '#fff !important',
        border: '0 !important',
        fontFamily: 'Lato, Arial, Helvetica, Helvetica Neue, serif !important'
    },
    languageSelect: {
        border: '0 !important',
        paddingRight: '28px !important'
    },
    languageInputArrow: {
        color: `${BUTTON_COLOR} !important`
    },
    selectedMenuItem: {
        display: 'none'
    },
    helpIcon: {
        width: 24,
        height: 24,
        marginLeft: 15,
        cursor: 'pointer'
    },
    tooltipContainer: {
        backgroundColor: '#fff !important',
        color: '#000 !important',
        borderRadius: '2px !important',
        boxShadow:
            '0 2px 2px 0 rgba(0, 0, 0, 0.24), 0 0 2px 0 rgba(0, 0, 0, 0.12) !important',
        padding: '24px 0px 24px 0px !important',
        fontFamily:
            'Lato, Roboto, Arial, Helvetica, Helvetica Neue, serif !important'
    },
    tooltipInnerContainer: {
        display: 'flex',
        flexDirection: 'column',
        flexWrap: 'wrap'
    },
    tooltipName: {
        fontWeight: 'bold',
        fontSize: 18,
        color: '#4A4A4A',
        paddingLeft: 30,
        paddingRight: 30
    },
    tooltipSeparator: {
        height: 1,
        width: '100%',
        backgroundColor: '#E9E9E9',
        marginTop: 16,
        marginBottom: 16
    },
    tooltipEmail: {
        fontSize: 16,
        color: '#4A4A4A',
        opacity: 0.5,
        marginTop: 6,
        paddingLeft: 30,
        paddingRight: 30
    },
    tooltipAppName: {
        fontSize: 16,
        color: '#4A4A4A',
        lineHeight: 1.4,
        paddingLeft: 30,
        paddingRight: 30
    },
    tooltipAppVersion: {
        fontSize: 16,
        fontWeight: 'normal',
        color: GREYISH_BROWN,
        opacity: 0.5,
        marginLeft: 5
    },
    tooltipPoper: {
        right: 36,
        left: 'auto !important',
        transform: 'initial !important',
        top: '47px !important'
    },
    break: {
        flexBasis: '100%',
        height: 0
    },
    tooltipMoreInfo: {
        fontSize: 16,
        fontWeight: 'normal',
        color: BUTTON_COLOR,
        cursor: 'pointer',
        marginTop: 10,
        paddingLeft: 30,
        paddingRight: 30
    },
    tooltipSignOut: {
        fontSize: 16,
        color: BUTTON_COLOR,
        cursor: 'pointer',
        paddingLeft: 30,
        paddingRight: 30
    },
    trafficLightsContainer: {
        marginRight: 'auto',
        height: 19,
        marginLeft: 16
    },
    focus: {
        '& $trafficLights > $trafficLightClose': {
            backgroundColor: '#ff6159'
        },
        '& $trafficLights > $trafficLightClose:active:hover': {
            backgroundColor: '#bf4942'
        },
        '& $trafficLights > $trafficLightMinimize': {
            backgroundColor: '#ffbd2e'
        },
        '& $trafficLights > $trafficLightMinimize:active:hover': {
            backgroundColor: '#bf8e22'
        },
        '& $trafficLights > $trafficLightMaximize': {
            backgroundColor: '#28c941'
        },
        '& $trafficLights > $trafficLightMaximize:active:hover': {
            backgroundColor: '#1d9730'
        }
    },
    trafficLights: {
        '& > $trafficLight::before, & > $trafficLight::after': {
            visibility: 'hidden'
        },
        '&:hover > $trafficLight::before, &:hover > $trafficLight::after, &:active > $trafficLight::before, &:active > $trafficLight::after': {
            visibility: 'visible'
        },
        '&:hover > $trafficLightClose, &:active > $trafficLightClose': {
            backgroundColor: '#ff6159'
        },
        '&:hover > $trafficLightClose:active:hover, &:active > $trafficLightClose:active:hover': {
            backgroundColor: '#bf4942'
        },
        '&:hover > $trafficLightMinimize, &:active > $trafficLightMinimize': {
            backgroundColor: '#ffbd2e'
        },
        '&:hover > $trafficLightMinimize:active:hover, &:active > $trafficLightMinimize:active:hover': {
            backgroundColor: '#bf8e22'
        },
        '&:hover > $trafficLightMaximize, &:active > $trafficLightMaximize': {
            backgroundColor: '#28c941'
        },
        '&:hover > $trafficLightMaximize:active:hover, &:active > $trafficLightMaximize:active:hover': {
            backgroundColor: '#1d9730'
        }
    },
    trafficLight: {
        borderRadius: '100%',
        padding: 0,
        height: 12,
        width: 12,
        border: '1px solid rgba(0, 0, 0, 0.06)',
        boxSizing: 'border-box',
        marginRight: 8,
        backgroundColor: '#ddd',
        position: 'relative',
        outline: 'none',

        '&::before, &::after': {
            content: '""',
            position: 'absolute',
            borderRadius: 1,
            left: 0,
            top: 0,
            right: 0,
            bottom: 0,
            margin: 'auto'
        }
    },
    trafficLightClose: {
        '&::before, &::after': {
            backgroundColor: '#4d0000',
            width: 8,
            height: 1
        },
        '&::before': {
            transform: 'rotate(45deg)'
        },
        '&::after': {
            transform: 'rotate(-45deg)'
        },
        '&:active:hover::before, &:active:hover::after': {
            backgroundColor: '#190000'
        }
    },
    trafficLightMinimize: {
        '&::before': {
            backgroundColor: '#995700',
            width: 8,
            height: 1
        },
        '&:active:hover::before': {
            backgroundColor: '#592800'
        }
    },
    trafficLightMaximize: {
        '&::before': {
            backgroundColor: '#006500',
            width: 6,
            height: 6
        },
        '&::after': {
            backgroundColor: '#28c941',
            width: 10,
            height: 2,
            transform: 'rotate(45deg)'
        },
        '&:active:hover::before': {
            backgroundColor: '#003200'
        },
        '&:active:hover::after': {
            backgroundColor: '#1d9730'
        }
    },
    trafficLightMaximizeDisabled: {
        '&::after': {
            backgroundColor: '#d1d1d1',
            border: 'solid 0.5px #b1b1b1',
            borderRadius: 'border-box',
            width: 10,
            height: 2,
            transform: 'rotate(45deg)'
        }
    }
});

export default styles;
